#include "CommunicationSender.h"
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <dirent.h>
#include <netdb.h>
#include <fcntl.h>
#include "../XmlParser/xmlParser.h"
#include <iostream>

namespace Communication
{

CommunicationSender::CommunicationSender()
{
}

CommunicationSender::~CommunicationSender()
{
}

bool CommunicationSender::RegisterReceiver(string key,int port, string ip)
{
	DestinationInfo dinfo;
	int sock;

	struct sockaddr_in name;
	
	sock = socket(AF_INET,SOCK_DGRAM,0);
	memset( &name, 0, sizeof(name));
	name.sin_family = AF_INET;
	name.sin_port = htons(port);
	name.sin_addr.s_addr = inet_addr(ip.data());
	
	dinfo.socket = sock;
	dinfo.name = name;

	//cout<<"Inserting receiver with key :"<<key << ", port"<<port<< ", ip:" << ip.data()<<endl;
	receivers.insert(make_pair(key,dinfo));
	return true;
}

bool CommunicationSender::SendMessage(string keytosend, string message)
{	
	if (receivers.find(keytosend)!=receivers.end())
	{
		DestinationInfo dinfo = receivers.find(keytosend)->second;
		int socket = dinfo.socket;
		struct sockaddr_in name= dinfo.name;
		sendto(socket, message.data(), message.size()+1,0, (struct sockaddr *)&name, sizeof(name));
		return true;
	}
	return false;
	
}

void CommunicationSender::FreeResources()
{
	std::map<string, DestinationInfo>::iterator iter;
	iter = receivers.begin();
	while (iter!=receivers.end())
	{
		DestinationInfo di = iter->second;
		close(di.socket);
		iter++;
	}
}

}
